/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college;

import foxie.rpg_college.Game;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Main {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        System.out.println("Hello World!");
        List<String> argsList = Arrays.asList(args);
        Optional<Object> scaling = Optional.empty();
        boolean isFullscreen = false;
        boolean doubleBuffer = true;
        for (String arg : argsList) {
            if (!arg.startsWith("scaling=")) continue;
            String argVal = arg.replaceFirst("^scaling=", "");
            scaling = Optional.of(Float.valueOf(Float.parseFloat(argVal)));
        }
        if (argsList.contains("fullscreen")) {
            isFullscreen = true;
        }
        if (argsList.contains("no_double_buffering")) {
            doubleBuffer = false;
        }
        if (scaling.isPresent() && !doubleBuffer) {
            System.out.println("Scaling render implies double buffering!");
            doubleBuffer = true;
        }
        try (Game game = new Game();){
            if (isFullscreen) {
                game.setFullscreen(true);
            }
            if (doubleBuffer) {
                game.setDoubleBuffer(true);
            }
            if (scaling.isPresent()) {
                game.setRenderScale(((Float)scaling.get()).floatValue());
            }
            while (!game.isClosed()) {
                game.runOnce();
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error cleaning up game:");
            e.printStackTrace();
        }
    }
}

