/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.entity;

import foxie.rpg_college.Bar;
import foxie.rpg_college.Game;
import foxie.rpg_college.entity.LivingEntity;
import java.awt.Color;

public abstract class CharacterEntity
extends LivingEntity {
    private float manaPoint = this.getMaxManaPoint();
    private Bar manaBar = new Bar(0.0f, this.manaPoint, this.getMaxManaPoint(), new Color(0.0f, 0.0f, 0.9f, 1.0f), new Color(0.8f, 0.8f, 0.9f, 1.0f));
    private float timeUntilManaRefill = -1.0f;

    public CharacterEntity(Game game) {
        super(game);
        this.addBar(this.manaBar);
    }

    public float getManaPoint() {
        return this.manaPoint;
    }

    public void setManaPoint(float newPoint) {
        this.manaBar.val = this.manaPoint = Math.max(0.0f, newPoint);
    }

    public boolean consumeManaPoint(float val) {
        if (this.manaPoint < val) {
            return false;
        }
        this.setManaPoint(this.manaPoint - val);
        if (this.timeUntilManaRefill < 0.0f) {
            this.timeUntilManaRefill = this.getManaRefillPeriod();
        }
        return true;
    }

    @Override
    public void tick(float deltaTime) {
        super.tick(deltaTime);
        if (this.getManaPoint() < this.getMaxManaPoint() && !this.isDead()) {
            this.timeUntilManaRefill -= deltaTime;
            if (this.timeUntilManaRefill < 0.0f) {
                this.timeUntilManaRefill = this.getManaRefillPeriod();
                this.setManaPoint(Math.min(this.getMaxManaPoint(), this.manaPoint + this.getManaRefillRate()));
            }
        }
    }

    public abstract float getManaRefillPeriod();

    public abstract float getManaRefillRate();

    public abstract float getMaxManaPoint();
}

