/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.entity;

import foxie.rpg_college.Bar;
import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.Game;
import foxie.rpg_college.IVec2;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.entity.Defenseable;
import foxie.rpg_college.entity.Entity;
import foxie.rpg_college.entity.controller.Controller;
import foxie.rpg_college.entity.controller.LivingEntityController;
import foxie.rpg_college.entity.damage.DamageSource;
import foxie.rpg_college.entity.damage.TileDamageSource;
import foxie.rpg_college.tile.Tile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Optional;

public abstract class LivingEntity
extends Entity {
    private float healthPoint = this.getMaxHealth();
    private Bar healthBar = new Bar(0.0f, this.healthPoint, this.getMaxHealth(), new Color(0.9f, 0.0f, 0.0f, 1.0f), new Color(0.7f, 0.4f, 0.4f, 1.0f));
    private float burnTimer = -1.0f;
    private float flashDuration = -1.0f;
    private float flashPeriod = -1.0f;
    private boolean flashState = false;
    private float timeToDie = 5.0f;
    public static final float FLASH_DURATION = 1.2f;
    public static final float FLASH_PERIOD = 0.1f;

    public LivingEntity(Game game) {
        super(game);
        this.addBar(this.healthBar);
    }

    public boolean canBurn() {
        return this.burnTimer <= 0.0f;
    }

    public boolean isDead() {
        return this.healthPoint <= 0.0f;
    }

    public float getHealth() {
        if (this.healthPoint <= 0.0f) {
            return 0.0f;
        }
        return this.healthPoint;
    }

    public void setHealth(float health) {
        this.healthPoint = health;
        if (this.healthPoint <= 0.0f) {
            this.healthPoint = -1.0f;
        } else if (this.healthPoint >= this.getMaxHealth()) {
            this.healthPoint = this.getMaxHealth();
        }
        this.healthBar.val = this.getHealth();
    }

    public void doDamage(DamageSource damageSource) {
        Defenseable defenseableEntity;
        if (this instanceof Defenseable && (defenseableEntity = (Defenseable)((Object)this)).canDefense()) {
            defenseableEntity.defend(damageSource);
        }
        if (damageSource.isCanceled()) {
            return;
        }
        float damage = damageSource.getDamagePoint();
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        this.setHealth(this.healthPoint - damage);
        this.flash();
    }

    public void flash() {
        this.flashDuration = 1.2f;
        this.flashPeriod = 0.1f;
        this.flashState = true;
    }

    public void resetFlash() {
        this.flashState = false;
        this.flashDuration = -1.0f;
        this.flashPeriod = -1.0f;
    }

    public boolean isFlashing() {
        return this.flashDuration > 0.0f;
    }

    public boolean getFlashState() {
        if (!this.isFlashing()) {
            return false;
        }
        return this.flashState;
    }

    @Override
    public void onTileStep(Tile tile, IVec2 tileCoord) {
        super.onTileStep(tile, tileCoord);
        if (tile == this.getWorld().getGame().TILES.LAVA_TILE && this.canBurn()) {
            this.burnTimer = 1.0f;
            this.doDamage(new TileDamageSource(tile, tileCoord, 15.0f));
        }
    }

    @Override
    public final Optional<FloatRectangle> getBoxToBeCheckedForTileStep() {
        return Optional.of(this.getLegBox());
    }

    @Override
    public void tick(float deltaTime) {
        this.burnTimer -= deltaTime;
        if (this.burnTimer < 0.0f) {
            this.burnTimer = -1.0f;
        }
        if (this.isFlashing()) {
            this.flashPeriod -= deltaTime;
            this.flashDuration -= deltaTime;
            if (this.flashPeriod < 0.0f) {
                this.flashPeriod = 0.1f;
                boolean bl = this.flashState = !this.flashState;
            }
        }
        if (this.isDead()) {
            this.timeToDie -= deltaTime;
            if (this.timeToDie < 0.0f) {
                this.die();
            }
        }
        this.healthBar.max = this.getMaxHealth();
    }

    public Vec2 getLegPos() {
        return this.getLegBox().getCenter();
    }

    public void die() {
        this.getWorld().removeEntity(this);
        if (this.canDispatchControllerEvents()) {
            this.getController().get().dispatchOnEntityNoLongerControllable();
        }
    }

    public boolean canBeAttacked() {
        return true;
    }

    @Override
    public void onEntityCollision(Entity other) {
    }

    @Override
    public void onTileCollision(IVec2 coord, Tile other) {
    }

    @Override
    public void onWorldBorderCollision() {
    }

    @Override
    public boolean canBeControlled() {
        return true;
    }

    @Override
    protected Controller createController() {
        return new LivingEntityController(this);
    }

    @Override
    public void render(Graphics2D g, float deltaTime) {
        super.renderBars(g);
    }

    public abstract FloatRectangle getLegBox();

    public abstract float getMaxHealth();

    public abstract float getMovementSpeed();
}

