/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.entity;

import foxie.rpg_college.Camera;
import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.Game;
import foxie.rpg_college.Orientation;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.entity.Attackable;
import foxie.rpg_college.entity.CharacterEntity;
import foxie.rpg_college.entity.CollisionBox;
import foxie.rpg_college.entity.Entity;
import foxie.rpg_college.entity.EntityHelper;
import foxie.rpg_college.entity.SwordEntity;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Optional;

public class WarriorCharacter
extends CharacterEntity
implements Attackable {
    private static final Vec2 SIZE = new Vec2(175.0f, 250.0f);
    private static final float SWORD_DAMAGE = 20.0f;
    private static final float SWORD_MANA_POINT = 20.0f;
    private final CollisionBox collisionBox = new CollisionBox(1.0f, new Vec2(0.0f, 0.0f), SIZE);
    private Optional<SwordEntity> sword = Optional.empty();

    public WarriorCharacter(Game game) {
        super(game);
    }

    @Override
    public float getManaRefillPeriod() {
        return 2.0f;
    }

    @Override
    public float getManaRefillRate() {
        return 40.0f;
    }

    @Override
    public float getMaxManaPoint() {
        return 100.0f;
    }

    @Override
    public FloatRectangle getLegBox() {
        FloatRectangle collision = this.collisionBox.asRect();
        Vec2 topLeftCollision = collision.getTopLeftCorner();
        Vec2 bottomRightCollision = collision.getBottomRightCorner();
        return new FloatRectangle(new Vec2(topLeftCollision.x(), bottomRightCollision.y() - SIZE.y() * 0.5f), bottomRightCollision);
    }

    @Override
    public float getMaxHealth() {
        return 150.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 70.0f;
    }

    @Override
    public boolean canCollideWith(Entity other) {
        return true;
    }

    @Override
    public Optional<CollisionBox> getCollisionBox() {
        return Optional.of(this.collisionBox);
    }

    @Override
    public boolean isVisible(Camera cam) {
        return true;
    }

    @Override
    public Optional<FloatRectangle> getRenderBound() {
        return Optional.of(EntityHelper.calculateRenderBox(this, SIZE));
    }

    @Override
    public void render(Graphics2D g, float deltaTime) {
        super.render(g, deltaTime);
        FloatRectangle renderBox = this.getRenderBound().get();
        Color color = new Color(0.8f, 0.4f, 0.8f);
        if (this.getFlashState()) {
            color = new Color(1.0f, 0.8f, 1.0f);
        }
        if (this.isDead()) {
            color = new Color(0.4f, 0.2f, 0.4f);
        }
        g.setColor(color);
        g.fillRect((int)renderBox.getTopLeftCorner().x(), (int)renderBox.getTopLeftCorner().y(), (int)renderBox.getSize().x(), (int)renderBox.getSize().y());
        if (this.sword.isPresent() && !this.sword.get().isDoneSwinging()) {
            this.sword.get().renderSword(g, deltaTime);
        }
    }

    @Override
    public boolean canAttack() {
        return (this.sword.isEmpty() || this.sword.get().isDoneSwinging()) && this.getManaPoint() >= 20.0f;
    }

    @Override
    public boolean attack() {
        if (!this.canAttack()) {
            return false;
        }
        if (!this.consumeManaPoint(20.0f)) {
            return false;
        }
        SwordEntity sword = new SwordEntity(this.getGame(), this, 20.0f, this.getRotation() - 80.0f, this.getRotation() + 80.0f, switch (this.getOrientation()) {
            default -> true;
            case Orientation.Left -> false;
        }, Vec2.unitVectorOfAngle(this.getRotation()).mul(Float.min(SIZE.x(), SIZE.y()) / 2.0f - 25.0f));
        this.getWorld().addEntity(sword);
        sword.updatePos();
        this.sword = Optional.of(sword);
        return true;
    }
}

