/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.entity.controller;

import foxie.rpg_college.Camera;
import foxie.rpg_college.Orientation;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.entity.Attackable;
import foxie.rpg_college.entity.Entity;
import foxie.rpg_college.entity.LivingEntity;
import foxie.rpg_college.entity.controller.ControlEventListener;
import foxie.rpg_college.entity.controller.Controller;
import foxie.rpg_college.input.Keyboard;
import foxie.rpg_college.input.Mouse;
import foxie.rpg_college.input.State;
import foxie.rpg_college.world.World;
import java.util.Optional;

public class InputToControllerBridge
implements AutoCloseable {
    private Optional<Controller> controller;
    private World currentWorld = null;
    private final Camera camera;
    private final ControlEventListener listener;

    public InputToControllerBridge(Entity entity, Vec2 viewSize, Vec2 outputSize) {
        if (!entity.canBeControlled()) {
            throw new IllegalArgumentException("Attempt to create InputToControllerBridge with non controllable entity");
        }
        this.controller = Optional.of(entity.getController().get());
        this.currentWorld = entity.getWorld();
        this.camera = new Camera(entity.getWorld().getRenderBound(), viewSize, outputSize);
        final InputToControllerBridge self = this;
        this.listener = new ControlEventListener(){
            final /* synthetic */ InputToControllerBridge this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onPositionUpdated() {
                Controller controller = self.controller.get();
                self.camera.setPosition(controller.getEntity().getPos());
            }

            @Override
            public void onEntityNoLongerControllable() {
                self.controller = Optional.empty();
            }

            @Override
            public void onWorldChange() {
                Controller controller = self.controller.get();
                if (controller.getEntity().getWorld() != null) {
                    self.camera.setBound(controller.getEntity().getWorld().getRenderBound());
                    self.camera.setPosition(controller.getEntity().getPos());
                    self.currentWorld = controller.getEntity().getWorld();
                }
            }
        };
        entity.getController().get().addListener(this.listener);
    }

    public void setNewEntityToControl(Entity entity) {
        if (!entity.canBeControlled()) {
            throw new IllegalArgumentException("Attempt to controll non-controllable entity");
        }
        if (this.controller.isPresent()) {
            this.controller.get().removeListener(this.listener);
        }
        Controller newController = entity.getController().get();
        newController.addListener(this.listener);
        this.controller = Optional.of(newController);
        this.listener.onWorldChange();
        this.listener.onPositionUpdated();
    }

    public World getWorld() {
        return this.currentWorld;
    }

    public Optional<Entity> getEntity() {
        return this.controller.map(Controller::getEntity);
    }

    @Override
    public void close() throws Exception {
        if (this.controller.isPresent()) {
            this.controller.get().removeListener(this.listener);
        }
    }

    public Optional<LivingEntity> getLivingEntity() {
        Entity entity;
        Optional<Entity> maybeEntity = this.getEntity();
        if (maybeEntity.isPresent() && (entity = maybeEntity.get()) instanceof LivingEntity) {
            return Optional.of((LivingEntity)entity);
        }
        return Optional.empty();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void handleInput(float deltaTime) {
        if (this.controller.isEmpty()) {
            return;
        }
        Controller controller = this.controller.get();
        Keyboard keyboard = this.getWorld().getGame().getKeyboard();
        Mouse mouse = this.getWorld().getGame().getMouse();
        if (controller.shouldControlDisabled()) {
            return;
        }
        if (this.getEntity().isPresent()) {
            Attackable attacker;
            Entity entity = this.getEntity().get();
            if (keyboard.getState(Keyboard.Button.Q).isNowPressed() && entity instanceof Attackable && (attacker = (Attackable)((Object)entity)).canAttack()) {
                attacker.attack();
            }
            if (keyboard.getState(Keyboard.Button.P) == State.Clicked) {
                System.out.println("Coord: " + entity.getPos().x() + ", " + entity.getPos().y());
            }
        }
        Vec2 moveMultiplier = new Vec2(0.0f, 0.0f);
        if (keyboard.getState(Keyboard.Button.W).isNowPressed()) {
            moveMultiplier = moveMultiplier.add(new Vec2(0.0f, -deltaTime));
        }
        if (keyboard.getState(Keyboard.Button.A).isNowPressed()) {
            moveMultiplier = moveMultiplier.add(new Vec2(-deltaTime, 0.0f));
        }
        if (keyboard.getState(Keyboard.Button.S).isNowPressed()) {
            moveMultiplier = moveMultiplier.add(new Vec2(0.0f, deltaTime));
        }
        if (keyboard.getState(Keyboard.Button.D).isNowPressed()) {
            moveMultiplier = moveMultiplier.add(new Vec2(deltaTime, 0.0f));
        }
        if (keyboard.getState(Keyboard.Button.Shift).isNowPressed()) {
            moveMultiplier = moveMultiplier.mul(3.0f);
        }
        controller.applyMovement(moveMultiplier);
        if (moveMultiplier.x() > 0.0f) {
            controller.setRotation(Orientation.Right.toDegrees());
        } else if (moveMultiplier.x() < 0.0f) {
            controller.setRotation(Orientation.Left.toDegrees());
        }
        if (moveMultiplier.y() < 0.0f) {
            controller.setRotation(Orientation.Up.toDegrees());
        } else if (moveMultiplier.y() > 0.0f) {
            controller.setRotation(Orientation.Down.toDegrees());
        }
        if (this.getEntity().isPresent()) {
            Entity entity = this.getEntity().get();
            if (mouse.getButtonState(Mouse.Button.Right).isNowPressed()) {
                Vec2 playerScreenCoord = entity.getPos();
                Vec2 lookToScreenCoord = this.camera.translateScreenToWorldCoord(mouse.getMousePosition()).sub(playerScreenCoord);
                controller.setRotation(lookToScreenCoord.calculateAngle());
            }
        }
    }
}

