/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.input;

import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.input.State;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Mouse
implements AutoCloseable {
    private final Object lock = new Object();
    private boolean[] buttonStateNow = new boolean[]{false, false, false};
    private boolean[] buttonStateClickedNow = new boolean[]{false, false, false};
    private Vec2 positionNow = new Vec2(0.0f, 0.0f);
    private boolean[] buttonStatePrev = new boolean[]{false, false, false};
    private State[] buttonState = new State[]{State.Unhold, State.Unhold, State.Unhold};
    private Vec2 positionSaved = new Vec2(0.0f, 0.0f);
    private final Listener listener = new Listener(this);
    private final Window window;
    private FloatRectangle watchedArea;
    private Vec2 mapWatchedArea;

    public Mouse(Window window, FloatRectangle watchedArea, Vec2 mapToArea) {
        this.window = window;
        this.watchedArea = watchedArea;
        this.mapWatchedArea = mapToArea;
        window.addMouseListener(this.listener);
        window.addMouseMotionListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWatchedArea(FloatRectangle watchedArea) {
        Object object = this.lock;
        synchronized (object) {
            this.watchedArea = watchedArea;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        Object object = this.lock;
        synchronized (object) {
            int i;
            for (i = 0; i < this.buttonState.length; ++i) {
                boolean prev = this.buttonStatePrev[i];
                boolean now = this.buttonStateNow[i];
                if (this.buttonStateClickedNow[i]) {
                    this.buttonState[i] = State.Clicked;
                    continue;
                }
                if (prev && now) {
                    this.buttonState[i] = State.Hold;
                    continue;
                }
                if (!prev && now) {
                    this.buttonState[i] = State.Clicked;
                    continue;
                }
                if (prev && !now) {
                    this.buttonState[i] = State.Unclicked;
                    continue;
                }
                if (prev || now) continue;
                this.buttonState[i] = State.Unhold;
            }
            for (i = 0; i < this.buttonStatePrev.length; ++i) {
                this.buttonStatePrev[i] = this.buttonStateNow[i];
            }
            for (i = 0; i < this.buttonStateClickedNow.length; ++i) {
                this.buttonStateClickedNow[i] = false;
            }
            this.positionSaved = this.positionNow;
        }
    }

    public State getButtonState(Button button) {
        return this.buttonState[button.ordinal()];
    }

    public Vec2 getMousePosition() {
        return this.positionSaved;
    }

    @Override
    public void close() throws Exception {
        this.window.removeMouseMotionListener(this.listener);
        this.window.removeMouseListener(this.listener);
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private final Mouse owner;

        public Listener(Mouse owner) {
            this.owner = owner;
        }

        boolean isInteresting(MouseEvent e) {
            return this.owner.watchedArea.contains(new Vec2(e.getX(), e.getY()));
        }

        void updatePosition(MouseEvent e) {
            if (!this.isInteresting(e)) {
                return;
            }
            Vec2 raw = new Vec2(e.getX(), e.getY());
            Vec2 offseted = raw.sub(this.owner.watchedArea.getTopLeftCorner());
            Vec2 percentMoved = offseted.div(this.owner.watchedArea.getSize());
            this.owner.positionNow = percentMoved.mul(this.owner.mapWatchedArea);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseExited(MouseEvent e) {
            Object object = this.owner.lock;
            synchronized (object) {
                if (!this.isInteresting(e)) {
                    return;
                }
                this.owner.buttonStateNow[0] = false;
                this.owner.buttonStateNow[1] = false;
                this.owner.buttonStateNow[2] = false;
                this.updatePosition(e);
            }
        }

        void updateButton(MouseEvent e, boolean val) {
            switch (e.getButton()) {
                case 1: {
                    this.owner.buttonStateNow[0] = val;
                    break;
                }
                case 2: {
                    this.owner.buttonStateNow[1] = val;
                    break;
                }
                case 3: {
                    this.owner.buttonStateNow[2] = val;
                }
            }
        }

        void updateButtonClicked(MouseEvent e, boolean val) {
            switch (e.getButton()) {
                case 1: {
                    this.owner.buttonStateClickedNow[0] = val;
                    break;
                }
                case 2: {
                    this.owner.buttonStateClickedNow[1] = val;
                    break;
                }
                case 3: {
                    this.owner.buttonStateClickedNow[2] = val;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            Object object = this.owner.lock;
            synchronized (object) {
                if (!this.isInteresting(e)) {
                    return;
                }
                this.updateButton(e, true);
                this.updatePosition(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            Object object = this.owner.lock;
            synchronized (object) {
                if (!this.isInteresting(e)) {
                    return;
                }
                this.updateButton(e, false);
                this.updateButtonClicked(e, false);
                this.updatePosition(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            Object object = this.owner.lock;
            synchronized (object) {
                if (!this.isInteresting(e)) {
                    return;
                }
                this.updatePosition(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent e) {
            Object object = this.owner.lock;
            synchronized (object) {
                if (!this.isInteresting(e)) {
                    return;
                }
                this.updatePosition(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            Object object = this.owner.lock;
            synchronized (object) {
                if (!this.isInteresting(e)) {
                    return;
                }
                this.updatePosition(e);
                this.updateButtonClicked(e, true);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }

    public static enum Button {
        Left,
        Middle,
        Right;

    }
}

