/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.ui;

import foxie.rpg_college.Game;
import foxie.rpg_college.entity.ArcherCharacter;
import foxie.rpg_college.entity.CatEntity;
import foxie.rpg_college.entity.Entity;
import foxie.rpg_college.entity.MageCharacter;
import foxie.rpg_college.entity.WarriorCharacter;
import foxie.rpg_college.input.Keyboard;
import foxie.rpg_college.input.State;
import foxie.rpg_college.ui.ScreenWithText;
import java.util.function.Function;

public class DeathScreen
extends ScreenWithText {
    private static final Respawnable[] RESPAWNABLES = new Respawnable[]{new Respawnable("Cat with sword", "1", Keyboard.Button.One, CatEntity::new), new Respawnable("Archer", "2", Keyboard.Button.Two, ArcherCharacter::new), new Respawnable("Mage", "3", Keyboard.Button.Three, MageCharacter::new), new Respawnable("Warrior", "4", Keyboard.Button.Four, WarriorCharacter::new)};
    private static final String TEXT = DeathScreen.build();

    private static String build() {
        StringBuilder builder = new StringBuilder();
        builder.append("YOU ARE DEAD!\n\n");
        for (Respawnable current : RESPAWNABLES) {
            builder.append(". Press ");
            builder.append(current.buttonInString);
            builder.append(" to respawn as ");
            builder.append(current.description);
            builder.append("\n");
        }
        builder.append("\nGood luck on your next attempt!");
        return builder.toString();
    }

    public DeathScreen(Game game) {
        super(game);
    }

    @Override
    public String getText() {
        return TEXT;
    }

    @Override
    public boolean handleInput() {
        Keyboard keyboard = this.getGame().getKeyboard();
        for (Respawnable current : RESPAWNABLES) {
            if (keyboard.getState(current.button) != State.Clicked) continue;
            this.getGame().respawn(current.constructor.apply(this.getGame()));
            break;
        }
        return false;
    }

    @Override
    public boolean canTickGame() {
        return false;
    }

    @Override
    public void tick(float deltaTime) {
    }

    private record Respawnable(String description, String buttonInString, Keyboard.Button button, Function<Game, Entity> constructor) {
    }
}

