/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.ui;

import foxie.rpg_college.Game;
import foxie.rpg_college.input.Keyboard;
import foxie.rpg_college.input.State;
import foxie.rpg_college.ui.Screen;
import foxie.rpg_college.ui.ScreenWithText;
import java.awt.Graphics2D;

public class HelpScreen
extends ScreenWithText {
    private final Screen prevScreen;
    private int currentPage = 0;
    private static final String[] PAGES = new String[]{"Controls (Help screen)\nArrow Left => Go to previous page\nArrow Right => Go to next page\n\nControls (Game)\nW, A, S, D => movements\nQ => Attack at current direction\n", "Controls (Game)\nRight click => Aim weapon at the clicked\nspot\nMinus key => Reduce render scale\nEquals key => Increase render scale\nF11 => Toggling fullscreen mode\n\n", "How to play:\nGo to right and you'll find two portals\ngreen on leads to game mode where you\nhave to survive longest with the turrets\n\nRight left side of you after starting\nyou find a portal that leads to gamemode\n", "where hostile creatures keep spawning\nmore and more in wave and the objective\nis to survive as long as possible\n\n\n\nBOoo!\n"};

    public HelpScreen(Game game, Screen prevScreen) {
        super(game);
        this.prevScreen = prevScreen;
    }

    @Override
    public String getText() {
        return "Page " + (this.currentPage + 1) + "/" + PAGES.length + ". Esc to quit.\n\n" + PAGES[this.currentPage];
    }

    @Override
    public boolean handleInput() {
        Keyboard keyboard = this.getGame().getKeyboard();
        if (keyboard.getState(Keyboard.Button.Escape) == State.Clicked) {
            this.getGame().setScreen(this.prevScreen);
            return false;
        }
        if (keyboard.getState(Keyboard.Button.ArrowLeft) == State.Clicked) {
            --this.currentPage;
            if (this.currentPage < 0) {
                this.currentPage = 0;
            }
        }
        if (keyboard.getState(Keyboard.Button.ArrowRight) == State.Clicked) {
            ++this.currentPage;
            if (this.currentPage >= PAGES.length) {
                this.currentPage = PAGES.length - 1;
            }
        }
        return false;
    }

    @Override
    public boolean canTickGame() {
        return false;
    }

    @Override
    public void tick(float deltaTime) {
    }

    @Override
    public void render(Graphics2D g, float deltaTime) {
        this.prevScreen.render(g, deltaTime);
        super.render(g, deltaTime);
    }
}

