/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.world;

import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.Game;
import foxie.rpg_college.IVec2;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.entity.Entity;
import foxie.rpg_college.entity.LivingEntity;
import foxie.rpg_college.entity.TurretEntity;
import foxie.rpg_college.texture.Texture;
import foxie.rpg_college.world.World;
import foxie.rpg_college.world.WorldUtil;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Optional;

public class BattleArena
extends World {
    private static final float RESPAWN_DELAY = 6.0f;
    private final Texture backgroundTexture;
    private final ArrayList<TurretEntity> turrets = new ArrayList();
    private boolean allTurretDestroyed = false;
    private float turretRespawnDelay = -1.0f;
    private int turretCount = 1;

    public BattleArena(Game game) {
        super(game, new FloatRectangle(new Vec2((float)(-game.getTextureManager().getTexture("world/battle_arena/background").width()) / 2.0f, (float)(-game.getTextureManager().getTexture("world/battle_arena/background").height()) / 2.0f), new Vec2((float)game.getTextureManager().getTexture("world/battle_arena/background").width() / 2.0f, (float)game.getTextureManager().getTexture("world/battle_arena/background").height() / 2.0f)));
        this.backgroundTexture = game.getTextureManager().getTexture("world/battle_arena/background");
        this.addTile(new IVec2(4, 0), game.TILES.LAVA_TILE);
        this.addTile(new IVec2(4, 4), game.TILES.PORTAL_TO_OVERWORLD);
        this.addTile(new IVec2(-3, 0), game.TILES.WALL_TILE);
        this.addTile(new IVec2(-2, 0), game.TILES.WALL_TILE);
        this.addTile(new IVec2(-1, 0), game.TILES.WALL_TILE);
        this.addTile(new IVec2(0, 0), game.TILES.WALL_TILE);
        this.addTile(new IVec2(1, 0), game.TILES.WALL_TILE);
        this.addTile(new IVec2(1, 1), game.TILES.WALL_TILE);
        this.addTile(new IVec2(1, 2), game.TILES.WALL_TILE);
        this.addTile(new IVec2(1, 3), game.TILES.WALL_TILE);
        this.spawnTurrets();
    }

    @Override
    public Vec2 getWorldSpawnPoint() {
        return new Vec2(-100.0f, 300.0f);
    }

    private void spawnTurrets() {
        float currentY;
        float maxY = (float)this.backgroundTexture.height() / 2.0f;
        float intervalY = (maxY - currentY) / (float)this.turretCount;
        float x = (float)this.backgroundTexture.width() / 2.0f - 100.0f;
        for (currentY = (float)(-this.backgroundTexture.height()) / 2.0f + 100.0f; currentY < maxY; currentY += intervalY) {
            TurretEntity turret = new TurretEntity(this.getGame());
            this.addEntity(turret);
            turret.setPos(new Vec2(x, currentY));
            this.turrets.add(turret);
        }
    }

    @Override
    public void tick(float deltaTime) {
        super.tick(deltaTime);
        if (this.allTurretDestroyed) {
            this.turretRespawnDelay -= deltaTime;
            if (this.turretRespawnDelay < 0.0f) {
                this.allTurretDestroyed = false;
                this.spawnTurrets();
                Optional<Entity> player = this.getGame().getPlayer();
                if (player.isPresent() && player.get() instanceof LivingEntity) {
                    LivingEntity playerEntity = (LivingEntity)player.get();
                    playerEntity.setHealth(playerEntity.getHealth() + playerEntity.getMaxHealth() * 0.25f);
                }
            }
        } else {
            int liveCount = 0;
            for (TurretEntity e : this.turrets) {
                if (e.isDead()) continue;
                ++liveCount;
            }
            if (liveCount == 0) {
                this.allTurretDestroyed = true;
                this.turretRespawnDelay = 6.0f;
                ++this.turretCount;
                this.turrets.clear();
            }
        }
    }

    @Override
    public void render(Graphics2D g, float deltaTime) {
        WorldUtil.renderBackground(this, g, this.backgroundTexture.image());
        super.render(g, deltaTime);
    }
}

